//-----------------------
// Life Above The Desert
//
// Skip Talbot
// July 7, 2004  
//-----------------------    

#include "functions.inc"

// GLOBAL SETTINGS -----------------


// 0 = No Rad
// 1 = Low Rad
// 2 = High Rad   

#declare focalBlur = 1;
#declare isoSurf   = 1; 
#switch 	    (2)

#case (0)
global_settings {
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.7
}
#break 

#case (1)
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 2.5
	hf_gray_16 off
	irid_wavelength <0.247059,0.176471,0.137255>
	max_intersections 64
	max_trace_level 15
	number_of_waves 10
	radiosity {      
		always_sample    off
		brightness       1.0  
		pretrace_start   0.08          
		pretrace_end     0.08 
		count            50
		distance_maximum 0.0
		error_bound      1.5
		gray_threshold   0.0
		low_error_factor 0.4
		minimum_reuse    0.015
		nearest_count    15
		recursion_limit  1
		media off
	}
}
#break

#case (2)
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 2.5
	hf_gray_16 off
	irid_wavelength <0.247059,0.176471,0.137255>
	max_intersections 32
	max_trace_level 10
	number_of_waves 10
	radiosity {      
		always_sample    off
		brightness       1.5  
		pretrace_start   0.08          
		pretrace_end     0.01 
		count            800
		distance_maximum 0.0
		error_bound      1.0
		gray_threshold   0.0
		low_error_factor 0.4
		minimum_reuse    0.015
		nearest_count    15
		recursion_limit  2
		media off
	}
}
#break

#end 





// CAMERA ----------------------------------
   
camera {
	location <0,75,0>
	look_at <100,100,0>
	up <0,1,0> 
	right <16/9,0,0> 
	#if (focalBlur=1) 
	focal_point < 5000, 1000, 0>   
  	aperture 10.0     
  	blur_samples 100 
  	variance 1/10000  
  	#end
}

//test cam  
  /*   
camera {
	location <0,75,0>
	look_at <0,220,100>
	up <0,1,0>
	right <16/9,0,0>  
	angle 170
}    
   */ 

// LIGHT SOURCES----------------------------
 

light_source {
	<-1,1,-1>*100000
	<1,1,1.0>*1.25
}   

// ATMOSPHERE-------------------------------


   

sky_sphere {
	pigment { gradient y 
		color_map {
			//[0.0 rgb <204/255,226/255,235/255>] 
			[0.0 rgb <120/255,200/255,243/255>] 
			//[0.3 rgb <15/255,80/255,170/255>]
			[0.8 rgb <0,0/255,100/255>]
		}
	}       
	pigment { gradient x 
		color_map {
			[0.0 rgbt 1] 
			[0.9 rgbt 1]  
			[0.975 rgb 1.0 ]
			[1.0 rgb <1,1,0.75>*2]
		}
		rotate 90*y scale 2 translate 1*z rotate 45*x rotate 45*y
	}
}


// Atmospheric media
// Reference:  emission <61/255,109/255,179/255>*0.00001 *   3 *100
//	       absorption <194/255,146/255,76/255>*0.00001 * 8 *100

/*   
fog {
  fog_type 1
  distance 20000
  color rgb <0,0/255,100/255>
}   */


fog {
  fog_type   2
  distance   8000
  color      <120/255,180/255,243/255>
  fog_offset 0.1
  fog_alt    1000
  turbulence 0.8
}   


// SCENE OBJECTS----------------------------

//  Sand Dunes     
//  Reference:  function { f_ridged_mf(x, y, z, H, Lacunarity, Octaves, Offset, Gain, 2)
//  Reference:  100*x, 300*x        

#declare duneFunc = function { pigment { function { f_ridged_mf(x,y,z,1,5,2,1.0,0,2)} scale <60,10,20> translate 687*x   }};
#declare rippleFunc = function { pigment { leopard turbulence 0.5 scale <.1,.1,4> } };
#declare bumpFunc = function { pigment { bumps  scale <50,50,50> } };  
#declare bumpFunc2 = function { pigment { bumps  color_map { [0.0 rgb 0.0] [0.1 rgb 1.0] [0.2 rgb 0] } scale <1,1,1> } };
	
#if (isoSurf=1)
isosurface {
	function { y - bumpFunc(x,y,z).grey*10 - duneFunc(x,y,z).grey*3 }
	contained_by {
		box { <0,-4,-1600>*10 <250,3.0,1600>*10 }   
	} 
	accuracy 0.001
	max_gradient 6
	pigment { rgb <255/255,185/255,100/255>*1.4 }
	finish { ambient .0 crand 0.1} 
	scale <4,8,4> 
	translate 50*z
}  
#end

/* */
plane {
	y, -1
	pigment { rgb <255/255,185/255,100/255>*1.4 }
	finish { ambient 0.05 }
}           
   
// Blimps
   
#include "zep89a.inc";
object { zep89a scale <1,1,-1>*10 translate <3000,750,-800> }
object { zep89a rotate -120*y scale <1,1,-1>*10 translate <5000,800,-3500> }
object { zep89a rotate 40*y scale <1,1,-1>*10 translate <7000,1600,2500> } 
object { zep89a rotate -150*y scale <1,1,-1>*10 translate <22000,6000,-1200> }   


#include "blimptrans.inc"
object {blimptrans rotate 20*y rotate 180*y scale 9 translate <5000, 800, -400> }
    
#include "blimpjet.inc" 
object {blimpjet rotate 150*y scale 10 translate <4500,300,-3500> } 
         

#include "blimpstripe.inc" 
object {blimpstripe rotate 45*y scale 10 translate <4500,1100,1000> } 
        
#include "blimpbug.inc" 
object {blimpbug rotate 5*y scale 10 translate <4000,1500,00> }  
 

 
 
#include "zep233envelope.inc";
object { zep233envelope rotate 180*y scale 10 translate <4000,2000,2000> }    
#include "zep233parts.inc" 
object {zep233parts rotate 180*y scale 10 translate <4000,2000,2000> } 
#include "zep233newparts.inc" 
object {zep233newparts rotate 180*y scale 10 translate <4000,2000,2000> }  

#include "station.inc"
object { station rotate 90*y scale 30 translate <15000, 6000, -5000> }

#include "stationtest.inc"
object { stationtest rotate 90*y scale 30 translate <15000, 6000, -5000> }   
  
 
#declare SilverSmall = material {
texture {
  pigment { color rgb 0.7 }
  finish  { ambient 0 phong 0.2 metallic }
  }
} 


#declare GoldSmall = material {
texture {
  pigment { color rgb <0.9,0.8,.4>*1.25 }
  finish  { ambient 0 phong 0.2 metallic }
  }
} 

#declare BronzeSmall = material {
texture {
  pigment { color rgb <0.9,0.6,.0> }
  finish  { ambient 0 phong 0.2 metallic }
  }
}

#declare BlueSmall = material {
texture {
  pigment { color rgb <0.7,0.7,.9>*1.05 }
  finish  { ambient 0 phong 0.2 metallic }
  }
} 

#declare WhiteSmall = material {
texture {
  pigment { color rgb 1 }
  finish  { ambient 0 phong 0.2 metallic }
  }
} 

#declare GreenSmall = material {
texture {
  pigment { color rgb <0.3,0.9,0.8>*1 }
  finish  { ambient 0 phong 0.2 metallic }
  }
}



#declare SandlightSmall = material {
texture {
  pigment { color rgb <255/255,185/255,100/255>*1.4 }
  finish  { ambient 0 reflection {0, .5} phong 0.2 metallic }
  }
}

#declare SanddarkSmall = material {
texture {
  pigment { color rgb <255/255,185/255,100/255>*0.3 }
  finish  { ambient 0 reflection {0, .5} phong 0.2 metallic }
  }
} 

#declare BlackSmall = material {
texture {
  pigment { color rgb 0.33 }
  finish  { ambient 0 reflection {0, .5} phong 0.2 metallic }
  }
}

#declare RedSmall = material {
texture {
  pigment { color rgb <1,0.4,0.1> }
  finish  { ambient 0 reflection {0, .5} phong 0.2 metallic }
  }
}

#include "blimpsmall.inc" 



#declare colorseed = seed(19);
#declare colorint = int(rand(colorseed)*10);

#declare rotateyseed = seed(60);
#declare transxseed = seed(61); 
#declare transyseed = seed(62);
#declare transzseed = seed(63); 


#declare Object1 = object {
   #include "blimpsmall1.inc"
} 

#declare blimpcount = 0;
#declare ccount = 60;  


#declare flightpath1 = function {
   spline {
     natural_spline
      0.00, <300,150,500>,
      0.25, <4000,750,0>,
      0.50, <7500, 2000, -1000>,
      0.75, <11000, 2000, -2000>,
      1.00, <15000, 6000, -5000>
   }
 }


#while (blimpcount < ccount ) 

union {        
		
	
	#switch (int(rand(colorseed)*10))
	
	#case (0)
	#declare blimpmaterial = GoldSmall;
	#break 
	
	#case (1)
	#declare blimpmaterial = SilverSmall;
	#break
	
	#case (2)
	#declare blimpmaterial = BronzeSmall;
	#break
	
	#case (3)
	#declare blimpmaterial = WhiteSmall;
	#break
	
	#case (4)
	#declare blimpmaterial = BlackSmall;
	#break    
	
	#case (5)
	#declare blimpmaterial = BlueSmall;
	#break
	
	#case (6)
	#declare blimpmaterial = RedSmall;
	#break
	
	#case (7)
	#declare blimpmaterial = GreenSmall;
	#break
	
	#case (8)
	#declare blimpmaterial = SandlightSmall;
	#break  
	
	#case (9)
	#declare blimpmaterial = SanddarkSmall;
	#break  
	#end
	
	#declare c = 0; 
	#while (c<colorint)
	 //sphere { 0, 1 pigment { rgb 1 } rotate 0*y scale 10 translate <300,200+c*20,0> }   
	#declare c = c + 1;
	#end
	 
	object {blimpsmall }
	object { Object1 material { blimpmaterial }   }
	scale 10  rotate 90*y rotate rand(rotateyseed)*20-10*y translate <flightpath1(blimpcount/ccount).x,flightpath1(blimpcount/ccount).y,flightpath1(blimpcount/ccount).z> translate rand(transxseed)*50*x translate rand(transyseed)*50*y translate rand(transzseed)*50*z
	
	}


#declare blimpcount = blimpcount + 1;
#end  

#declare rotateyseed = seed(60);
#declare transxseed = seed(61); 
#declare transyseed = seed(62);
#declare transzseed = seed(63); 


#declare Object1 = object {
   #include "blimpsmall1.inc"
} 

#declare blimpcount = 0;
#declare ccount = 20;  


#declare flightpath2 = function {
   spline {
     natural_spline
      0.00, <3500,1000,5000>,
      0.25, <3500,1900,1000>,
      0.50, <7500, 3000, -1000>,
      0.75, <11000, 4000, -2000>,
      1.00, <15000, 6000, -5000>
   }
 }


#while (blimpcount < ccount ) 

union {        
		
	
	#switch (int(rand(colorseed)*10))
	
	#case (0)
	#declare blimpmaterial = GoldSmall;
	#break 
	
	#case (1)
	#declare blimpmaterial = SilverSmall;
	#break
	
	#case (2)
	#declare blimpmaterial = BronzeSmall;
	#break
	
	#case (3)
	#declare blimpmaterial = WhiteSmall;
	#break
	
	#case (4)
	#declare blimpmaterial = BlackSmall;
	#break    
	
	#case (5)
	#declare blimpmaterial = BlueSmall;
	#break
	
	#case (6)
	#declare blimpmaterial = RedSmall;
	#break
	
	#case (7)
	#declare blimpmaterial = GreenSmall;
	#break
	
	#case (8)
	#declare blimpmaterial = SandlightSmall;
	#break  
	
	#case (9)
	#declare blimpmaterial = SanddarkSmall;
	#break  
	#end
	
	#declare c = 0; 
	#while (c<colorint)
	 //sphere { 0, 1 pigment { rgb 1 } rotate 0*y scale 10 translate <300,200+c*20,0> }   
	#declare c = c + 1;
	#end
	 
	object {blimpsmall }
	object { Object1 material { blimpmaterial }   }
	scale 10 rotate 180*y rotate -90*blimpcount/ccount*y translate <flightpath2(blimpcount/ccount).x,flightpath2(blimpcount/ccount).y,flightpath2(blimpcount/ccount).z> translate rand(transxseed)*50*x translate rand(transyseed)*50*y translate rand(transzseed)*50*z
	
	}


#declare blimpcount = blimpcount + 1;
#end  

#declare blimpcount = 0;
#declare ccount = 40;  


#declare flightpath3 = function {
   spline {
     natural_spline
      0.00, <100,750,-1000>,
      0.25, <4000,1200,-500>,
      0.50, <7500, 2000, -1000>,
      0.75, <11000, 2000, -2000>,
      1.00, <15000, 6000, -5000>
   }
 }


#while (blimpcount < ccount ) 

union {        
		
	
	#switch (int(rand(colorseed)*10))
	
	#case (0)
	#declare blimpmaterial = GoldSmall;
	#break 
	
	#case (1)
	#declare blimpmaterial = SilverSmall;
	#break
	
	#case (2)
	#declare blimpmaterial = BronzeSmall;
	#break
	
	#case (3)
	#declare blimpmaterial = WhiteSmall;
	#break
	
	#case (4)
	#declare blimpmaterial = BlackSmall;
	#break    
	
	#case (5)
	#declare blimpmaterial = BlueSmall;
	#break
	
	#case (6)
	#declare blimpmaterial = RedSmall;
	#break
	
	#case (7)
	#declare blimpmaterial = GreenSmall;
	#break
	
	#case (8)
	#declare blimpmaterial = SandlightSmall;
	#break  
	
	#case (9)
	#declare blimpmaterial = SanddarkSmall;
	#break  
	#end
	
	#declare c = 0; 
	#while (c<colorint)
	 //sphere { 0, 1 pigment { rgb 1 } rotate 0*y scale 10 translate <300,200+c*20,0> }   
	#declare c = c + 1;
	#end
	 
	object {blimpsmall }
	object { Object1 material { blimpmaterial }   }
	scale 10  rotate 90*y rotate rand(rotateyseed)*20-10*y translate <flightpath3(blimpcount/ccount).x,flightpath3(blimpcount/ccount).y,flightpath3(blimpcount/ccount).z> translate rand(transxseed)*50*x translate rand(transyseed)*50*y translate rand(transzseed)*50*z
	
	}


#declare blimpcount = blimpcount + 1;
#end  


#declare blimpcount = 0;
#declare ccount = 10000; 

#while (blimpcount < ccount ) 

union {        
		
	
	#switch (int(rand(colorseed)*10))
	
	#case (0)
	#declare blimpmaterial = GoldSmall;
	#break 
	
	#case (1)
	#declare blimpmaterial = SilverSmall;
	#break
	
	#case (2)
	#declare blimpmaterial = BronzeSmall;
	#break
	
	#case (3)
	#declare blimpmaterial = WhiteSmall;
	#break
	
	#case (4)
	#declare blimpmaterial = BlackSmall;
	#break    
	
	#case (5)
	#declare blimpmaterial = BlueSmall;
	#break
	
	#case (6)
	#declare blimpmaterial = RedSmall;
	#break
	
	#case (7)
	#declare blimpmaterial = GreenSmall;
	#break
	
	#case (8)
	#declare blimpmaterial = SandlightSmall;
	#break  
	
	#case (9)
	#declare blimpmaterial = SanddarkSmall;
	#break  
	#end
	
	#declare c = 0; 
	#while (c<colorint)
	 //sphere { 0, 1 pigment { rgb 1 } rotate 0*y scale 10 translate <300,200+c*20,0> }   
	#declare c = c + 1;
	#end
	 
	object {blimpsmall }
	object { Object1 material { blimpmaterial }   }
	scale 10 rotate 180*y rotate rand(rotateyseed)*20*y translate 5000*x translate 6000*rand(transxseed)*x rotate rand(rotateyseed)*y*360  translate rand(transyseed)*5000*y-2500 translate <15000, 6000, -5000>
	
	}

   // 
#declare blimpcount = blimpcount + 1;
#end


//  translate rand(transxseed)*5000*x rotate rand(rotateyseed)*360  translate <10000, 2000, -2000>



	

